package ws.afterglo.audioPod;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import java.util.ArrayList;
import java.io.*;

import javax.swing.*;

/**
 * @author muti
 * modified by philippe
 *
 */
public class UI {
    private RecentPanel	recentpanel;
    private JTextArea	logtextarea;
    private JButton submitB;
    private JButton cacheB;
    private JButton AllPlaysB;
    private JFrame frame;
    
    
    public void buildUI() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        frame = new JFrame("AudioPod goes iScrobbler v0.7b");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize.width *= 0.90;
        screenSize.height *= 0.85;
        frame.setSize(screenSize);
        
        int x=(int)(Toolkit.getDefaultToolkit().getScreenSize().width/2-frame.getWidth()/2);
        int y=(int)(Toolkit.getDefaultToolkit().getScreenSize().height/2-frame.getHeight()/2);
        frame.setLocation(x,y);
        
        GridBagLayout layout = new GridBagLayout();
        frame.getContentPane().setLayout(layout);
        
        GridBagConstraints c = new GridBagConstraints();
        c.fill = GridBagConstraints.BOTH;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = GridBagConstraints.REMAINDER;
        
        this.recentpanel = new RecentPanel();
        layout.setConstraints(this.recentpanel, c);
        frame.getContentPane().add(this.recentpanel);
        
        c.weighty = 0.5;
        this.logtextarea = new JTextArea("=====LOG=====\n");
        this.logtextarea.setLineWrap(true);
        this.logtextarea.setWrapStyleWord(true);
        this.logtextarea.setEditable(false);
        
        JScrollPane scrollpane = new JScrollPane(this.logtextarea);
        layout.setConstraints(scrollpane, c);
        frame.getContentPane().add(scrollpane);
        
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        
        JMenuBar mb=new JMenuBar();
        JMenu m=new JMenu("Options");
        m.setMnemonic(KeyEvent.VK_O);
        
        JMenuItem iPrefs=new JMenuItem("Preferences");
        iPrefs.setMnemonic(KeyEvent.VK_P);
        iPrefs.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                PreferencesEditor prefeditor = new PreferencesEditor(frame);
                prefeditor.buildUI();
            }
        });
        m.add(iPrefs);
        
        m.addSeparator();
        
        JMenuItem iExit=new JMenuItem("Exit");
        iExit.setMnemonic(KeyEvent.VK_X);
        iExit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
                System.exit(0);
            }
        });
        m.add(iExit);
        
        mb.add(m);
        frame.setJMenuBar(mb);
 
        JPanel bottom=new JPanel();
        submitB = new JButton("Submit Tracks");
        submitB.setMnemonic(KeyEvent.VK_S);
        submitB.setToolTipText("Will submit tracks to audioscrobbler (online)");
        submitB.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
            	if(!setToSubmit())
            		return;
            	AudioPod.logger.log(Level.INFO,"*** Submitting tracks ***");
                if(AudioPod.SubmitTracks()){
                	if(AudioPod.delPlaysEnabled){
                		File f=new File(AudioPod.iTDBPath.charAt(0)+":\\iPod_Control\\iTunes\\Play Counts");
                		if(f.isFile())
                			f.delete();
                	}   
                	if(AudioPod.ce){
	                	boolean sysExit=false;
	                	Runtime rt = Runtime.getRuntime();
	                	if(!AudioPod.hdmounted || (new File(AudioPod.hddrive+":\\")).isDirectory()){
	                		try{
	                			if(AudioPod.iTEnabled && AudioPod.waEnabled){
	                				String s=AudioPod.defaultPlayer;
	                				if(s.equals("iTunes"))
	                					rt.exec(AudioPod.iTunesPath);
	                				else if(s.equals("Winamp"))
	                					rt.exec(AudioPod.winampPath);
	                			}else if(AudioPod.iTEnabled)
	                				rt.exec(AudioPod.iTunesPath);
	                			else if(AudioPod.waEnabled)
	                				rt.exec(AudioPod.winampPath);
	                			sysExit=true;
	                		}catch(IOException e){
	                			AudioPod.logger.log(Level.SEVERE, "Error launching iTunes. Is '"+AudioPod.iTunesPath+"' the correct path?");
	                		}
	                	}else{
	                		AudioPod.logger.log(Level.INFO,"Player not launched because "+AudioPod.hddrive+":\\ is not mounted");
	                		sysExit=false;
	                	}    	
	                	if(sysExit){
	                		System.exit(0);
	                	}
                	}
                }
                AudioPod.recentplayed=new ArrayList();
            	AudioPod.ParsePlayCounts();
                AudioPod.UI.newTrackListAvailable();
            }
        });
        bottom.add(submitB);
        
        cacheB = new JButton("Cache Tracks");
        cacheB.setMnemonic(KeyEvent.VK_C);
        cacheB.setToolTipText("Will cache tracks to iScrobbler (offline)");
        cacheB.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
            	boolean sysExit=false;
            	boolean succ=false;
            	String player="";
            	if(!setToSubmit())
            		return;
            	//What to do when both players are used
            	if(AudioPod.iTEnabled && AudioPod.waEnabled){
            		Object[] possibilities = {"iTunes", "Winamp"};
            		player = (String)JOptionPane.showInputDialog(
                            new JFrame(),
                            "To which cache do you want to write the tracks?\n",
                            "Choose cache",
                            JOptionPane.PLAIN_MESSAGE,
                            null,
                            possibilities,
                            AudioPod.defaultPlayer);
            		Preferences fPrefs = Preferences.userRoot().node("ws/afterglo/audioPod");
            		if(player!=null){
                    	AudioPod.logger.log(Level.INFO,"*** Caching tracks ***");
	            		if(player.equals("iTunes")){
	            			succ=AudioPod.ToiScrobbler();
	            			fPrefs.put("default player", "iTunes");
	            			File f=new File(AudioPod.waCachePath);
	            			if(f.isFile())
	            				f.delete();
	            		}else if(player.equals("Winamp")){
	            			succ=AudioPod.ToWinamp();
	            			IScrobbler.clearCache();
	            			fPrefs.put("default player", "Winamp");
	            		}
            		}else
            			return;
            	}
            	//If only iTunes is used
            	else if(AudioPod.iTEnabled){
            		succ=AudioPod.ToiScrobbler();
            		player="iTunes";
            	}
            	//If only Winamp is used
            	else if(AudioPod.waEnabled){
            		succ=AudioPod.ToWinamp();
            		player="Winamp";
            	}
            	//If no player is enabled
            	else if(!AudioPod.iTEnabled && !AudioPod.waEnabled)
            		 JOptionPane.showMessageDialog(new JFrame(), "No player enabled. Can't write to any cache.", "Warning", JOptionPane.WARNING_MESSAGE);
                //Cache & Exit option
            	if(succ && AudioPod.ce){
                	Runtime rt = Runtime.getRuntime();
                	if(!AudioPod.hdmounted || (new File(AudioPod.hddrive+":\\")).isDirectory()){
                			try{
                				if(player.equals("iTunes")){
                					rt.exec(AudioPod.iTunesPath);
                				}
                				else if(player.equals("Winamp"))
                					rt.exec(AudioPod.winampPath);
                				sysExit=true;
                			}catch(IOException e){
                				AudioPod.logger.log(Level.SEVERE, "Error launching Player.");
                			}
                	}else{
                		AudioPod.logger.log(Level.INFO, "Player not launched, because the drive "+AudioPod.hddrive+":\\ is not mounted.");
            			sysExit=false;
                	}
                }
            	//deletePlays otion
            	if(succ && AudioPod.delPlaysEnabled){
            		File f2=new File(AudioPod.iTDBPath.charAt(0)+":\\iPod_Control\\iTunes\\Play Counts");
            		if(f2.isFile())
            			f2.delete();
            	}
            	if(sysExit)
            		System.exit(0);
                AudioPod.recentplayed=new ArrayList();
            	AudioPod.ParsePlayCounts();
                AudioPod.UI.newTrackListAvailable();
            }
        });
        bottom.add(cacheB);
        
        AllPlaysB = new JButton("XML Tracks");
        AllPlaysB.setMnemonic(KeyEvent.VK_C);
        AllPlaysB.setToolTipText("Will cache AllPlays XML (offline)");
        AllPlaysB.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ev) {
            	boolean sysExit=false;
            	boolean succ=false;
            	String player="";
            	if(!setToSubmit())
            		return;
            	//If only iTunes is used
            	if(AudioPod.iTEnabled){
            		succ=AudioPod.ToAllPlays();
            		player="iTunes";
            	}
                //Cache & Exit option
            	if(succ && AudioPod.ce){
                	Runtime rt = Runtime.getRuntime();
                	if(!AudioPod.hdmounted || (new File(AudioPod.hddrive+":\\")).isDirectory()){
                			try{
                				if(player.equals("iTunes")){
                					rt.exec(AudioPod.iTunesPath);
                				}
                				else if(player.equals("Winamp"))
                					rt.exec(AudioPod.winampPath);
                				sysExit=true;
                			}catch(IOException e){
                				AudioPod.logger.log(Level.SEVERE, "Error launching Player.");
                			}
                	}else{
                		AudioPod.logger.log(Level.INFO, "Player not launched, because the drive "+AudioPod.hddrive+":\\ is not mounted.");
            			sysExit=false;
                	}
                }
            	//deletePlays otion
            	if(succ && AudioPod.delPlaysEnabled){
            		File f2=new File(AudioPod.iTDBPath.charAt(0)+":\\iPod_Control\\iTunes\\Play Counts");
            		if(f2.isFile())
            			f2.delete();
            	}
            	if(sysExit)
            		System.exit(0);
                AudioPod.recentplayed=new ArrayList();
            	AudioPod.ParsePlayCounts();
                AudioPod.UI.newTrackListAvailable();
            }
        });
        bottom.add(AllPlaysB);
        
        frame.getContentPane().add(bottom);
        
        if(!AudioPod.cacheAndExitiT && !AudioPod.cacheAndExitWa)
        	frame.setVisible(true);
    }
    
    public boolean setToSubmit(){
    	AudioPod.toSubmit=new ArrayList();
    	int [] selectedTracks=recentpanel.getSelectedRows();
    	//Check if an entry is selected
		if (AudioPod.selectEnabled){
			if(selectedTracks.length==0){
				JOptionPane.showMessageDialog(
                    new JFrame(),
                    "No tracks selected",
                    "Info",
                    JOptionPane.INFORMATION_MESSAGE);
				return false;
			}
			int n=0;
			for(int i=0;i<AudioPod.recentplayed.size();i++){
				if(n<selectedTracks.length && i==selectedTracks[n]){
					AudioPod.toSubmit.add((TrackItem)AudioPod.recentplayed.get(i));
					n++;
				}
			}
		}else
			AudioPod.toSubmit=AudioPod.recentplayed;
		return true;
    }
    
    public void disableCacheB(){
    	cacheB.setEnabled(false);
    }
    
    public void disableAllPlaysB(){
    	AllPlaysB.setEnabled(false);
    }
    
    public void disableSubmitB(){
    	submitB.setEnabled(false);
    }
    public void enableCacheB(){
    	cacheB.setEnabled(true);
    }
    
    public void enableAllPlaysB(){
    	AllPlaysB.setEnabled(true);
    }
    
    public void enableSubmitB(){
    	submitB.setEnabled(true);
    }
    
    public void newTrackListAvailable() {
        this.recentpanel.newTrackListAvailable();
    }
    
    public JTextArea getLogtextarea() {
        return this.logtextarea;
    }
}
